VERSION 5.00
Begin VB.UserControl DPC_Maintenance 
   ClientHeight    =   6945
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   13320
   ScaleHeight     =   6945
   ScaleWidth      =   13320
   Begin VB.Frame fra_Maintenance 
      Height          =   6012
      Left            =   120
      TabIndex        =   2
      Top             =   0
      Width           =   13092
      Begin VB.Frame fra_Main 
         Height          =   5772
         Left            =   120
         TabIndex        =   3
         Top             =   120
         Width           =   12852
         Begin Project1.ArmGrid grd_BoxMain 
            Height          =   5292
            Left            =   120
            TabIndex        =   4
            Top             =   240
            Width           =   11772
            _ExtentX        =   20770
            _ExtentY        =   9340
         End
         Begin Project1.ToolbarControl tlb_BoxMain 
            Height          =   4500
            Left            =   12000
            TabIndex        =   5
            Tag             =   "2924"
            Top             =   240
            Width           =   696
            _ExtentX        =   1217
            _ExtentY        =   7938
         End
      End
   End
   Begin VB.CommandButton btn_Quit 
      Height          =   612
      Left            =   12600
      Style           =   1  'Graphical
      TabIndex        =   1
      Tag             =   "btn_Quit"
      Top             =   6240
      Width           =   612
   End
   Begin VB.CommandButton btn_Validate 
      Height          =   612
      Left            =   11880
      Style           =   1  'Graphical
      TabIndex        =   0
      Tag             =   "btn_Validate"
      Top             =   6240
      Width           =   612
   End
End
Attribute VB_Name = "DPC_Maintenance"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const SEP = ""
Private Const C_SEP As String = "@@"
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const CL_COLOR_ENABLED As Long = &H80000005
Private Const CL_COLOR_DISABLED As Long = &H8000000F
Private Const CL_COLOR_LOCKED As Long = &H80000018
Private Const SCREEN_NAME As String = "DPC_Maintenance"

Private Const SW_SHOWNORMAL = 1

Private Const LOCALE_SDECIMAL = &HE ' Decimal separator
Private Const LOCALE_STHOUSAND = &HF ' Thousand separator
Private Const LOCALE_USER_DEFAULT = &H400
Private Const C_ERRORRAISE As Long = 2500
Private Const C_MSG_ID_BASE As Long = 9700

Private Const FRM_SPACE_VER = 120
Private Const FRM_SPACE_HOR = 100

Public Result As Boolean

#If ENV = LIVE Then
Private mo_Sys As Object
Public mo_Db As Object
Public mo_UnlockDb As Object
#Else
Private mo_Sys As ARMSYSCOMLib.ArmSYS
Public mo_Db As ARMSYSCOMLib.ArmDb
Public mo_UnlockDb As ARMSYSCOMLib.ArmDb
#End If

Private mo_Tools As DPC_Tools

Public CanChangeManualPrice As Boolean
Public CURR_Code As String
Public CT_Code As String
Public ValidityDate As Date
Public ml_U_Code As Long

Private me_Screen As eDPCScreenMode
Private me_SubScreen As eDPCScreenMode

Private mb_InternalInit As Boolean
Private mb_CurrentTextBoxChanged As Boolean
Private ms_Caption As String
Private ms_DPCImageCachePath As String
Private mb_Initialized As Boolean
Private ms_DecimalSeparator As String
Private ms_ThousandSeparator As String
Private mc_ScreenLabels As Long
Private mc_Toolbars As Long
Private mo_FSO As FileSystemObject
Private mo_WshNetwork As Object
Private ms_ComputerName As String
Private ms_Language_Code                As String       'current user interface language
Private ms_LoginName                    As String       'contain loginname
Private ms_UserName                     As String       'contain name of logged user as defined in GEN_People
Private ms_Conn()                       As String

Private Enum ArmErr
    DBCnxFailed = C_ERRORRAISE + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = C_ERRORRAISE + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = C_ERRORRAISE + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = C_ERRORRAISE + 4
    PropertyNotSet = C_ERRORRAISE + 5
    SQLFailure = C_ERRORRAISE + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = C_ERRORRAISE + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = C_ERRORRAISE + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = C_ERRORRAISE + 9
    CompFncFailed = C_ERRORRAISE + 10           ' when component function fail
    GridLoadFailed = C_ERRORRAISE + 11          ' load function failed ... bad sql
    InvalidValue = C_ERRORRAISE + 12          ' load function failed ... bad sql
End Enum

Private Enum ArmCusErr
    DuplicityDetected = C_ERRORRAISE + 2301                ' detected row with same unique id
End Enum

Public Event quit()

Public Property Set ArmDb(ByRef ao_Db As Object)
On Error GoTo ErrorHandler

  Set mo_Db = ao_Db
  Exit Property
ErrorHandler:
  Call ErrorHandler("ArmDb.Set")
End Property

Public Property Set Tools(ByRef ao_Tools As Object)
On Error GoTo ErrorHandler

  Set mo_Tools = ao_Tools
  Exit Property
ErrorHandler:
  Call ErrorHandler("Tools.Set")
End Property

Public Property Let Language_Code(ByVal as_Language_Code As String)
On Error GoTo ErrHandler
  
  ms_Language_Code = as_Language_Code
  Exit Property
ErrHandler:
  Call ErrorHandler("Language_Code.Let")
End Property

Public Property Get Language_Code() As String
On Error GoTo ErrHandler
  
  Language_Code = ms_Language_Code
  Exit Property
ErrHandler:
  Call ErrorHandler("Language_Code.Get")
End Property

Public Property Let U_Code(ByVal al_U_Code As Long)
On Error GoTo ErrorHandler

  ml_U_Code = al_U_Code
  Exit Property
ErrorHandler:
  Call ErrorHandler("U_Code.Let")
End Property

Public Property Let LoginName(ByVal as_Value As String)
On Error GoTo ErrorHandler

  ms_LoginName = as_Value
  Exit Property
ErrorHandler:
  Call ErrorHandler("LoginName.Let")
End Property

Public Property Let Caption(ByVal as_Value As String)
On Error GoTo ErrHandler
    
  ms_Caption = as_Value
  Exit Property
ErrHandler:
  Call ErrorHandler("Caption.Let")
End Property

Public Property Get Caption() As String
On Error GoTo ErrHandler
    
  Caption = ms_Caption
  Exit Property
ErrHandler:
  Call ErrorHandler("Caption.Get")
End Property

Public Property Let Name(ByVal as_Value As String)
On Error GoTo ErrHandler
    
  UserControl.Extender.Name = as_Value
  Exit Property
ErrHandler:
  Call ErrorHandler("Name.Let")
End Property

Public Property Get Name() As String
On Error GoTo ErrHandler
    
  Name = UserControl.Extender.Name
  Exit Property
ErrHandler:
  Call ErrorHandler("Name.Get")
End Property

Public Property Let Tag(ByVal as_Value As String)
On Error GoTo ErrHandler
    
  UserControl.Tag = as_Value
  Exit Property
ErrHandler:
  Call ErrorHandler("Tag.Let")
End Property

Public Property Get Tag() As String
On Error GoTo ErrHandler
    
  Tag = UserControl.Tag
  Exit Property
ErrHandler:
  Call ErrorHandler("Tag.Get")
End Property

Public Property Let Visible(ByVal aVisible As Boolean)
On Error GoTo ErrHandler
    
  UserControl.Extender.Visible = aVisible
  Exit Property
ErrHandler:
  Call ErrorHandler("Visible.Let")
End Property

Public Property Get Visible() As Boolean
On Error GoTo ErrHandler
    
  Visible = UserControl.Extender.Visible
  Exit Property
ErrHandler:
  Call ErrorHandler("Visible.Get")
End Property

Public Property Let Top(ByVal aTop As Single)
On Error GoTo ErrHandler
    
  UserControl.Extender.Top = aTop
  Exit Property
ErrHandler:
  Call ErrorHandler("Top.Let")
End Property

Public Property Get Top() As Single
On Error GoTo ErrHandler
    
  Top = UserControl.Extender.Top
  Exit Property
ErrHandler:
  Call ErrorHandler("Top.Get")
End Property

Public Property Let Height(ByVal aHeight As Single)
On Error GoTo ErrHandler
    
  UserControl.Extender.Height = aHeight
  Exit Property
ErrHandler:
  Call ErrorHandler("Height.Let")
End Property

Public Property Get Height() As Single
On Error GoTo ErrHandler
    
  Height = UserControl.Extender.Height
  Exit Property
ErrHandler:
  Call ErrorHandler("Height.Get")
End Property

Public Property Let Left(ByVal aLeft As Single)
On Error GoTo ErrHandler
    
  UserControl.Extender.Left = aLeft
  Exit Property
ErrHandler:
  Call ErrorHandler("Left.Let")
End Property

Public Property Get Left() As Single
On Error GoTo ErrHandler
    
  Left = UserControl.Extender.Left
  Exit Property
ErrHandler:
  Call ErrorHandler("Left.Get")
End Property

Public Property Let Width(ByVal aWidth As Single)
On Error GoTo ErrHandler
    
  UserControl.Extender.Width = aWidth
  Exit Property
ErrHandler:
  Call ErrorHandler(".Let")
End Property

Public Property Get Width() As Single
On Error GoTo ErrHandler
    
  Width = UserControl.Extender.Width
  Exit Property
ErrHandler:
  Call ErrorHandler("Width.Get")
End Property

Public Sub Move(ByVal aLeft As Single, ByVal aTop As Single, ByVal aWidth As Single, ByVal aHeight As Single)
On Error GoTo ErrHandler
  
  Call UserControl.Extender.Move(aLeft, aTop, aWidth, aHeight)
  Exit Sub
ErrHandler:
  Call ErrorHandler("Move")
End Sub

Public Property Let Enabled(ByVal ab_Value As Boolean)
On Error GoTo ErrHandler

  UserControl.Enabled = ab_Value
  Exit Property
ErrHandler:
  Call ErrorHandler("Enabled.Let")
End Property

Public Property Get Enabled() As Boolean
 On Error GoTo ErrHandler

  Enabled = UserControl.Enabled
  Exit Property
ErrHandler:
  Call ErrorHandler("Enabled.Get")
End Property

Public Sub Zorder()
On Error GoTo ErrHandler

  Call UserControl.Extender.Zorder
  Exit Sub
ErrHandler:
  Call ErrorHandler("Zorder")
End Sub

Public Sub Refresh()
On Error GoTo ErrHandler

  Call UserControl.Refresh
  Exit Sub
ErrHandler:
  Call ErrorHandler("Refresh")
End Sub

Public Property Get hwnd() As Long
On Error GoTo ErrHandler
  
  hwnd = UserControl.hwnd
  Exit Property
ErrHandler:
  Call ErrorHandler("hwnd.Get")
End Property

Public Property Get Initialized() As Boolean
On Error GoTo ErrHandler
    
  Initialized = mb_Initialized
  Exit Property
ErrHandler:
  Call ErrorHandler("Initialized.Get")
End Property

Public Function Load_A_Com() As Boolean
On Error GoTo ErrHandler

Dim ll_Idx As Integer
Dim ls_Request As String
Dim lsa_PKG_Id() As String

    
  Load_A_Com = False
  
  If mb_Initialized Then
      Call Err.Raise(ArmErr.CPTAlreadyInitialized)
  End If
  If mo_Db Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  If mo_Tools Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  
  If Not mo_Tools.HasSecurityAlias(ms_LoginName, "DPC_MAINTENANCE") Then
     Exit Function
  End If
    
  mb_InternalInit = True
  Call mo_Tools.Load_A_ComControls(UserControl.Controls, mo_Db, ms_Language_Code)
  
  ms_DecimalSeparator = Format(0, ".")
  ms_ThousandSeparator = mo_Tools.GetLocaleInfo(LOCALE_USER_DEFAULT, LOCALE_STHOUSAND)
  mc_Toolbars = 0
  
  Set mo_FSO = CreateObject("Scripting.FileSystemObject")
  
#If ENV = LIVE Then
  Set mo_Sys = CreateObject("ArmSYSCOM.ArmSys")
  Set mo_UnlockDb = CreateObject("ARMSYSCOM.ArmDb")
#Else
  Set mo_Sys = New ARMSYSCOMLib.ArmSYS
  Set mo_UnlockDb = New ARMSYSCOMLib.ArmDb
#End If
  
  Set mo_WshNetwork = CreateObject("WScript.Network")
  ms_ComputerName = mo_WshNetwork.ComputerName
    
  Call tlb_BoxMain.SetToolbarInfoStringParameters("001EE01760QESFGIDR/BACALLBCC", "001")
  Call tlb_BoxMain.DisplayFace("0")
  tlb_BoxMain.Visible = True
  
  ReDim la_Columns(7) As Variant
  la_Columns(0) = "COF_Id" & CH_LDELIMIT & "0" & CH_LDELIMIT & "1" & CH_LDELIMIT & "COF_Id" & CH_LDELIMIT & "#COF Id"
  la_Columns(1) = "COF_Code" & CH_LDELIMIT & "1500" & CH_LDELIMIT & "0" & CH_LDELIMIT & "COF_Code" & CH_LDELIMIT & "#COF Code"
  la_Columns(2) = "SP_Desc" & CH_LDELIMIT & "3000" & CH_LDELIMIT & "0" & CH_LDELIMIT & "SP_Desc" & CH_LDELIMIT & "#SP Desc"
  la_Columns(3) = "CCU_Desc" & CH_LDELIMIT & "3000" & CH_LDELIMIT & "0" & CH_LDELIMIT & "CCU_Desc" & CH_LDELIMIT & "#CCU Desc"
  la_Columns(4) = "Z_LockOwn" & CH_LDELIMIT & "1000" & CH_LDELIMIT & "0" & CH_LDELIMIT & "Z_LockOwn" & CH_LDELIMIT & "#Lock Own"
  la_Columns(5) = "Z_LockDate" & CH_LDELIMIT & "1000" & CH_LDELIMIT & "0" & CH_LDELIMIT & "Z_LockDate" & CH_LDELIMIT & "#Lock Date"
  la_Columns(6) = "Z_LockProc" & CH_LDELIMIT & "1000" & CH_LDELIMIT & "0" & CH_LDELIMIT & "Z_LockProc" & CH_LDELIMIT & "#Lock Proc"
  la_Columns(7) = "ProcExists" & CH_LDELIMIT & "600" & CH_LDELIMIT & "0" & CH_LDELIMIT & "ProcExists" & CH_LDELIMIT & "#Exists"
  grd_BoxMain.SetColumns la_Columns
    
  ms_DPCImageCachePath = App.Path & DPC_IMAGE_CACHE
  ms_Caption = "#Maintenance"
  btn_Validate.Picture = LoadResPicture(RES_OK, 1)
  btn_Quit.Picture = LoadResPicture(RES_QUIT, 1)

  'Call mo_Tools.EnableFrame(UserControl.Controls, fra_Data, False)
  
  'Call mo_Tools.LoadToolbars(mo_Db, UserControl.Controls, "DPC", SCREEN_NAME)
  'Screen csts
  mc_ScreenLabels = mo_Tools.LoadLabels(mo_Db, UserControl.Controls, Me, SCREEN_NAME, ms_Language_Code)
  Call mo_Tools.ChangeCharset(UserControl.Controls, gl_CodePage)
  
  ms_Conn = Split(mo_Tools.GetAConfigData("DPC_UNLOCK_CON"), SEP1 & SEP2)
  
  Call LoadBox
  
  Result = False
  mb_InternalInit = False
  mb_Initialized = True
  Load_A_Com = mb_Initialized
  Exit Function
ErrHandler:
  Call ErrorHandler("Load_A_COM")
End Function

Public Sub Unload_A_Com()
On Error GoTo ErrHandler

  Call mo_Tools.Unload_A_ComControls(UserControl.Controls)
  Call mo_Db.Close(mc_ScreenLabels)
  Set mo_Sys = Nothing
  Set mo_FSO = Nothing
  Set mo_Db = Nothing
  Set mo_UnlockDb = Nothing
  
  mb_Initialized = False
  Exit Sub
ErrHandler:
  Call ErrorHandler("Unload_A_COM")
End Sub

Private Sub LoadBox()
On Error GoTo ErrHandler

Dim ls_Req As String

    'ms_Conn = Split(mo_Tools.GetAConfigData("DPC_UNLOCK_CON"), SEP1 & SEP2)
    
    If Not mo_UnlockDb.Connect(ms_Conn(0), ms_Conn(1), ms_Conn(2), ms_Conn(3), SCREEN_NAME) Then
        Call MsgBox("Cannot connect")
        End
    End If
  
    grd_BoxMain.UnBound = False
    Set grd_BoxMain.ArmDb = mo_UnlockDb
  
    Call grd_BoxMain.Load("exec DPC_Maintenance_lst", True)
  
    grd_BoxMain.UnBound = True
    Set grd_BoxMain.ArmDb = Nothing
    
    Call mo_UnlockDb.Disconnect
  Exit Sub

ErrHandler:
  Call ErrorHandler("LoadBox")
End Sub

Private Sub btn_Validate_Click()
  Result = True
  RaiseEvent quit
End Sub

Private Sub UnlockRecord(ByVal as_COF_Id As String, ByVal as_LockProc As Integer, ByVal as_ProcExists As String)
On Error GoTo ErrHandler

Dim ls_Req As String

  If as_ProcExists = "X" Then
    
    
    If Not mo_UnlockDb.Connect(ms_Conn(0), ms_Conn(1), ms_Conn(2), ms_Conn(3), SCREEN_NAME) Then
        Call MsgBox("Cannot connect")
        End
    End If
    
    ls_Req = "Kill " & as_LockProc
    Call mo_Tools.ExecuteSQLSafe(mo_UnlockDb, ls_Req)
  
    Call mo_UnlockDb.Disconnect
  
  End If
  
  ls_Req = "UPDATE Cap_Offer SET Z_LockOwn='', Z_LockDate=NULL, Z_LockProc=NULL WHERE COF_Id = $COF_Id$"
  ls_Req = Replace(ls_Req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id))
  
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_Req, 1)
  
  Exit Sub
ErrHandler:
  Call ErrorHandler("UnlockRecord")
End Sub

Public Sub Resize()
On Error GoTo ErrHandler

  'Call tbs_Main.Move(0, 0, Me.Width)
  'Call fra_Main(0).Move(0, tbs_Main.Height, Me.Width, Me.Height - tbs_Main.Height)
  'Call fra_Main(1).Move(0, tbs_Main.Height, Me.Width, Me.Height - tbs_Main.Height)
  
  'fra_Main(0).Visible = tbs_Main.SelectedItem.Index = 1
  'fra_Main(1).Visible = tbs_Main.SelectedItem.Index = 2
  
  'Call grd_BoxSummary.Move(0, 0, fra_Main(0).Width, fra_Main(0).Height)
  'Call grd_BoxMain.Move(0, 0, fra_Main(1).Width - tlb_BoxItemsMain.Width)
  'Call grd_BoxItemMain.Move(0, grd_BoxMain.Top + grd_BoxMain.Height + 200, fra_Main(1).Width - tlb_BoxItemsMain.Width)
  
  Exit Sub
ErrHandler:
  Call ErrorHandler("Resize")
End Sub


Private Function ReplaceCommonPlaceholders(ByVal as_Request As String) As String
On Error GoTo ErrHandler

  as_Request = Replace(as_Request, "$Z_Creator$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
  as_Request = Replace(as_Request, "$U_Code$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
  as_Request = Replace(as_Request, "$Z_Last_Upd_User$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
  as_Request = Replace(as_Request, "$Language_Code$", mo_Tools.SQLStr(ms_Language_Code), , , vbTextCompare)
  ReplaceCommonPlaceholders = as_Request
  Exit Function
ErrHandler:
  Call ErrorHandler("ReplaceCommonPlaceholders")
End Function

' display standard error message
Public Sub ErrorMessage(ByVal as_Fct As String)
    Dim ls_ErrSource As String
    Dim ls_errDescription As String
    Dim ls_Message As String
    
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_errDescription = Err.Description
    ls_Message = SCREEN_NAME & " exception. Nr:" & Err.Number & ",Desc: " & ls_errDescription & ",Src:" & ls_ErrSource & "@"
    Call mo_Tools.LogMessage(mo_Db, ml_U_Code, SCREEN_NAME, ls_Message, "E")
    Call MsgBox("Error occured, please contact IT. Application will now shutdown." & vbCrLf & ls_ErrSource & vbCrLf & "Description: " & ls_errDescription, vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
    End
End Sub

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
  
    Call Err.Raise(Err.Number, Extender.Name & "." & as_Fct & SEP1 & Err.Source, Err.Description)
End Sub


Private Sub tlb_BoxMain_action(ByVal as_Role As String, as_Language As String)
On Error GoTo ErrHandler
   
    If Not tlb_BoxMain.Enabled Then Exit Sub
    
    Call mo_Tools.LockScreen(Me, True)
    
    Select Case as_Role
            
        Case "B"
        ' Want to Update
            If grd_BoxMain.SelectedCount = 1 Then
                'Call Item_UpdateInit(ll_DetailConfigIndex, grd_Main(ll_MainFrameIndex).CurrentKey)
            End If
        Case "C"
        ' Want to delete
            If grd_BoxMain.SelectedCount = 1 Then
                If MsgBox("Are you sure to delete this process? It will shut down the application for user who is currently editing this offer with COF_Id = " & grd_BoxMain.SelectedLine(0, "COF_Id") & "?", vbOKCancel, SCREEN_NAME) = vbOK Then
                    Call UnlockRecord(grd_BoxMain.CurrentKey(0), grd_BoxMain.SelectedLine(0, "Z_LockProc"), grd_BoxMain.SelectedLine(0, "ProcExists"))
                    Call grd_BoxMain.DeleteSelectedLines
                End If
            End If
        Case "L"
        ' Want to reload treeview and refresh the grid
            Call LoadBox
            'grd_BoxMain.Refresh
        Case Else
            Err.Raise ArmErr.InvalidArgument, "tlb_BoxMain_action", "Unknown main toolbar role as_Role=" & as_Role
    End Select
    
    Call mo_Tools.LockScreen(Me, False)
    
    Exit Sub
ErrHandler:
    Call mo_Tools.UpdateError(True)
    Call mo_Tools.LockScreen(Me, False)

    Select Case Err.Number
    Case 202
        Call mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 202, "#The item you have added/updated couldn't be displayed with the current criteria set.", , vbInformation + vbOKOnly)
    Case ArmErr.SQLBadRowExpectedCount
        Call mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 2138, "#The record you try to open has been deleted by an other user. Please refresh the grid.", , vbInformation)
    Case ArmErr.SQLBadRowAffectedCount
        Call mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 2144, "#This record has been, modified by an other.Please exit from this screen and refresh the grid.", , vbInformation)
    Case Else
        ' Call LogMessage("tlb_list_action")
        ' user interface can be inconsistent, better to close application
        Call mo_Tools.UpdateError(False)
        Call MsgBox("Error occured, please contact IT. Application will now shutdown." & vbCrLf & Err.Source & vbCrLf & "Description: " & Err.Description, vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
        End
    End Select
End Sub
